/////////////////////////////////////////////////////////////////////////////
// ~nab: decent random number generator

#pragma once
#define TRNDSEED long

/* HARD-KODED GENERATOR SCHEME
   There exists the option of specifying if the slow'n'goodna or the quick
   and dirty versions of the random number generators are used, via the 
   preprocessor flag QND_RANDOM_SCHEME. With #ifdef blocks then the code
   necessaru is included or excluded and the rest of the program is 
   completely unaware of the changes. This method has been selected instead
   of a say normal run-time flag mainly due to the extension in the code 
   size that would have resulted.
 */
/* min/maxi numbers returned by the IRxxx functions; all are INCLUSIVE */
/* these are the limits of the PROPER generators */
#define IR_RNDMIN 1          /* NOTE that zero is OUT! */
/* the signed arithmetic used somehow limits the range to 2^31... */
#define IR_RNDMAX 2147483646 /* this is one LESS than the modulo used */


/* next two OK, since RNDMAX is already properly assigned by scheme */
#define MODULO (IR_RNDMAX+1) /* period of generated rnd number sequence */
#define RND_INVMOD (1.0/MODULO) /* speedup divisions wiv this one */

#ifdef __cplusplus
extern "C" { // important for cross C/C++ projects
#endif // __cplusplus

/* GLOBAL seed, shared by ALL generators */
__declspec(selectany) TRNDSEED rnd_seed = 1; // in case they forget to initialize
#ifdef _DEBUG
__declspec(selectany) int seed_called_ = 0;
#endif
/* this initialises the seed of the random number generators */
/* MUST be called before using IRRandom() etc, for true random sequences */
static void InitRnd()
{
   /* so the generators needn't check for intialization every time! */
#ifdef _WINDOWS_
   rnd_seed = GetTickCount(); /* surely <> 0, so MASK is junked in my kode */
#else
	rnd_seed=time(NULL); /* surely <> 0, so MASK is junked in my kode */
#endif
	if(!rnd_seed) {
		int i=0; // in lieu of assert
		i = 1/i;
	}

#ifdef _DEBUG
	seed_called_++; // only once is enough but doesn't hurt more
#endif

#ifdef _WINDOWS_
	Sleep(0); // ensure we won't get called straight away a 2nd time
#endif
} /* InitRnd() */

/* now on to the main rnd generator selection... */
/* constants for posh generator */
#define IA 16807
#define IQ 127773
#define IR 2836
/* minimal decent random number generator; function ran0() in p.279 */
/* for double returns in (0,1) multiply with RND_INVMOD (speedup divs) */
static __inline TRNDSEED IRRandom(void) /* for max speed/max code size! */
{
   long k;

#ifdef _DEBUG
	if(!seed_called_) {
		printf("*** forgot to initialize RND seed?\n");
		seed_called_ = 1;
	}
#endif

   /* compute (IA*seed)%MOD without overflows by Schrage's method */
   k=rnd_seed/IQ; /* integer division, not requiring speedup */
   rnd_seed=IA*(rnd_seed-k*IQ)-IR*k; /* update seed... */
   if(rnd_seed<0) rnd_seed+=MODULO;  /* ...with possible correction */

   return rnd_seed;
} /* IRRandom() */

#ifdef __cplusplus
}
#endif // __cplusplus

// replace standard random functions
#define RAND_MAX IR_RNDMAX
#define rand() IRRandom()
#define srand(x) InitRnd()