// xfan.h by N.A.Bozinis @ 10-Apr-20 1:21:57 PM
// file setting up building with FANN library (in %FANN% path)
// documentation: http://leenissen.dk/fann/html/files/fann-h.html
// @@@ if you need C++ interface see fann_cpp.h

#define FANN_NO_DLL
#if 0 // now I embedd the source so we don't depend on libraries
#pragma comment(lib, "fannfloat.lib")
#pragma comment(lib, "fanndouble.lib")
#endif

// FANN_NO_SEED? -> let it use its own random

#ifndef NN_USEFLOAT
#ifdef _WIN64
#define NN_USEFLOAT /* faster */
#endif 
#endif

// add this to additional include directories: $(FANN)\include
#ifdef NN_USEFLOAT
#ifndef _WIN64
#pragma message("floats are dead slow in 32 bits!") // double time really!
#endif
#include "floatfann.h"
#include "../floatfann.c"

#else
#include "doublefann.h"
#include "../doublefann.c"
#endif

#define NN_NUMF fann_type

/* exact 0-1 targets are bad idea for squashing function (derivatives =>0) */
/* if you need to simulate ranges outside [0,1] must change the squashing function */

#define SQUASH_HIGH 1
#ifndef SYMMETRIC_SIGMOID
// plain sigmoid is also 10% slower, dunno why!?
#define SQUASH_LOW 0 // plain sigmoid; symmetric is -1
#define F_ACT FANN_SIGMOID
#else
#define SQUASH_LOW -1
#define F_ACT FANN_SIGMOID_SYMMETRIC
#endif

#define TARGET_HIGH (0.90f*SQUASH_HIGH) // @@@ sometimes try their scaling
#if SQUASH_LOW != 0
#define TARGET_LOW (0.90f*SQUASH_LOW)
#else
#define TARGET_LOW (0.10f)
#endif


// get weight statistics
inline void fann_stats(struct fann *ann)
{
	fann_type *last_weight;
	fann_type *weights = ann->weights;
	NN_NUMF a, wm=0, wx=0, ave=0;

	last_weight = weights + ann->total_connections;
	for(; weights != last_weight; )
	{
		//*weights = (fann_type) (fann_rand(min_weight, max_weight));
		a = *weights++;
		if(a > wx)
			wx = a;
		else if(a < wm)
			wm = a;

		ave += a;
	}
	ave /= ann->total_connections;

	// delta derivative info pou exn? train_slopes
	printf("\nWmax=%g, min=%g, ave=%g, average delta=%g?? (~zero delta=%d%%)\n", wx, wm, ave, 0.0, 0);
}